<?php
function series() { 
    $labels = array( 
        'name'                => _x( 'Series', 'Post Type General Name', 'text_domain' ), 
        'singular_name'       => _x( 'Series', 'Post Type Singular Name', 'text_domain' ), 
        'menu_name'           => __( 'Series', 'text_domain' ), 
        'parent_item_colon'   => __( 'Parent Series:', 'text_domain' ), 
        'all_items'           => __( 'All Series', 'text_domain' ), 
        'view_item'           => __( 'View Series', 'text_domain' ), 
        'add_new_item'        => __( 'Add Series', 'text_domain' ), 
        'add_new'             => __( 'Add Series', 'text_domain' ), 
        'edit_item'           => __( 'Edit Series', 'text_domain' ), 
        'update_item'         => __( 'Update Series', 'text_domain' ), 
        'search_items'        => __( 'Search series', 'text_domain' ), 
        'not_found'           => __( 'Not Found', 'text_domain' ), 
        'not_found_in_trash'  => __( 'Not Found', 'text_domain' ), 
    ); 
    $args = array( 
        'label'               => __( 'series', 'text_domain' ), 
        'description'         => __( 'Series', 'text_domain' ), 
        'labels'              => $labels, 
        'supports'            => array( 'title', 'editor', 'thumbnail', 'comments','author'), 
        'taxonomies'          => array( 'genre','type','post_tag','writer','artist' ), 
        'hierarchical'        => false, 
        'public'              => true, 
        'show_ui'             => true, 
        'show_in_menu'        => true, 
        'show_in_nav_menus'   => true, 
        'show_in_admin_bar'   => true, 
        'menu_position'       => 5, 
        'menu_icon'           => 'dashicons-book', 
        'can_export'          => true, 
        'has_archive'         => true, 
        'exclude_from_search' => false, 
        'publicly_queryable'  => true, 
        'capability_type'     => 'post', 
		'rewrite' => array( 
			'slug' => 'series',
			'with_front' => FALSE,
		),
    ); 
    register_post_type( 'series', $args ); 

} 

// Hook into the 'init' action 
add_action( 'init', 'series', 0 ); 

// blog type
function blog() {

	$labels = array(
		'name'                => _x( 'Blogs', 'Post Type General Name', 'text_domain' ),
		'singular_name'       => _x( 'Blogs', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'           => __( 'Blogs', 'text_domain' ),
		'name_admin_bar'      => __( 'Blogs', 'text_domain' ),
		'parent_item_colon'   => __( 'Parent Blog:', 'text_domain' ),
		'all_items'           => __( 'All Blogs', 'text_domain' ),
		'add_new_item'        => __( 'Add New Blog', 'text_domain' ),
		'add_new'             => __( 'Add New', 'text_domain' ),
		'new_item'            => __( 'New Blog', 'text_domain' ),
		'edit_item'           => __( 'Edit Blog', 'text_domain' ),
		'update_item'         => __( 'Update Blog', 'text_domain' ),
		'view_item'           => __( 'View Blog', 'text_domain' ),
		'search_items'        => __( 'Search Blog', 'text_domain' ),
		'not_found'           => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'  => __( 'Not found in Trash', 'text_domain' ),
	);
	$args = array(
		'label'               => __( 'Blogs', 'text_domain' ),
		'description'         => __( 'Blogs', 'text_domain' ),
		'labels'              => $labels,
		'supports'            => array( 'title', 'editor', 'thumbnail', 'comments', 'author' ),
		'taxonomies'          => array( 'label' ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => 5,
		'menu_icon'           => 'dashicons-welcome-write-blog',
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'has_archive'         => true,		
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
		'rewrite' => array( 
			'slug' => 'blog',
			'with_front' => FALSE,
		),
	);
	register_post_type( 'blog', $args );

}
add_action( 'init', 'blog', 0 );

// labels taxonomy
function label() {

	$labels = array(
		'name'                       => _x( 'Labels', 'Taxonomy General Name', 'text_domain' ),
		'singular_name'              => _x( 'Labels', 'Taxonomy Singular Name', 'text_domain' ),
		'menu_name'                  => __( 'Labels', 'text_domain' ),
		'all_items'                  => __( 'All Labels', 'text_domain' ),
		'parent_item'                => __( 'Parent Label', 'text_domain' ),
		'parent_item_colon'          => __( 'Parent Label:', 'text_domain' ),
		'new_item_name'              => __( 'New Label Name', 'text_domain' ),
		'add_new_item'               => __( 'Add New Label', 'text_domain' ),
		'edit_item'                  => __( 'Edit Label', 'text_domain' ),
		'update_item'                => __( 'Update Label', 'text_domain' ),
		'view_item'                  => __( 'View Label', 'text_domain' ),
		'separate_items_with_commas' => __( 'Separate genres with commas', 'text_domain' ),
		'add_or_remove_items'        => __( 'Add or remove labels', 'text_domain' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'text_domain' ),
		'popular_items'              => __( 'Popular Labels', 'text_domain' ),
		'search_items'               => __( 'Search Labels', 'text_domain' ),
		'not_found'                  => __( 'Not Found', 'text_domain' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => false,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'rewrite' => array( 
			'slug' => 'label',
			'with_front' => FALSE,
		),
	);
	register_taxonomy( 'label', array( 'blog' ), $args );

}
add_action( 'init', 'label', 0 );

// Register Taxonomy Genre 
function genre() { 
    $labels = array( 
        'name'                       => _x( 'Genre', 'Taxonomy General Name', 'text_domain' ), 
        'singular_name'              => _x( 'Genre', 'Taxonomy Singular Name', 'text_domain' ), 
        'menu_name'                  => __( 'Genre', 'text_domain' ), 
        'all_items'                  => __( 'All Genre', 'text_domain' ), 
        'parent_item'                => __( 'Parent Genre', 'text_domain' ), 
        'parent_item_colon'          => __( 'Parent Genre:', 'text_domain' ), 
        'new_item_name'              => __( 'New Genre Name', 'text_domain' ), 
        'add_new_item'               => __( 'Add New Genre', 'text_domain' ), 
        'edit_item'                  => __( 'Edit Genre', 'text_domain' ), 
        'update_item'                => __( 'Update Genre', 'text_domain' ), 
        'separate_items_with_commas' => __( 'Separate Genre with commas', 'text_domain' ), 
        'search_items'               => __( 'Search Genre', 'text_domain' ), 
        'add_or_remove_items'        => __( 'Add or remove genre', 'text_domain' ), 
        'choose_from_most_used'      => __( 'Choose from the most used genre', 'text_domain' ), 
        'not_found'                  => __( 'Not Found', 'text_domain' ), 
    ); 
    $args = array( 
        'labels'                     => $labels, 
        'hierarchical'               => false, 
        'public'                     => true, 
        'show_ui'                    => true, 
        'show_admin_column'          => true, 
        'show_in_nav_menus'          => true, 
        'show_tagcloud'              => true, 
		'rewrite' => array( 
			'slug' => 'genre',
			'with_front' => FALSE,
		),
    ); 
    register_taxonomy( 'genre', array( 'series' ), $args ); 

} 

// Hook into the 'init' action 
add_action( 'init', 'genre', 0 ); 

function type() { 
    $labels = array( 
        'name'                       => _x( 'Type', 'Taxonomy General Name', 'text_domain' ), 
        'singular_name'              => _x( 'Type', 'Taxonomy Singular Name', 'text_domain' ), 
        'menu_name'                  => __( 'Type', 'text_domain' ), 
        'all_items'                  => __( 'All Type', 'text_domain' ), 
        'parent_item'                => __( 'Parent Type', 'text_domain' ), 
        'parent_item_colon'          => __( 'Parent Type:', 'text_domain' ), 
        'new_item_name'              => __( 'New Type Name', 'text_domain' ), 
        'add_new_item'               => __( 'Add New Type', 'text_domain' ), 
        'edit_item'                  => __( 'Edit Type', 'text_domain' ), 
        'update_item'                => __( 'Update Type', 'text_domain' ), 
        'separate_items_with_commas' => __( 'Separate Type with commas', 'text_domain' ), 
        'search_items'               => __( 'Search Type', 'text_domain' ), 
        'add_or_remove_items'        => __( 'Add or remove type', 'text_domain' ), 
        'choose_from_most_used'      => __( 'Choose from the most used type', 'text_domain' ), 
        'not_found'                  => __( 'Not Found', 'text_domain' ), 
    ); 
    $args = array( 
        'labels'                     => $labels, 
        'hierarchical'               => false, 
        'public'                     => true, 
        'show_ui'                    => true, 
        'show_admin_column'          => true, 
        'show_in_nav_menus'          => true, 
        'show_tagcloud'              => true, 
		'rewrite' => array( 
			'slug' => 'type',
			'with_front' => FALSE,
		),
    ); 
    register_taxonomy( 'type', array( 'series' ), $args ); 

} 

// Hook into the 'init' action 
add_action( 'init', 'type', 0 ); 

function writer() { 
    $labels = array( 
        'name'                       => _x( 'Writer', 'Taxonomy General Name', 'text_domain' ), 
        'singular_name'              => _x( 'Writer', 'Taxonomy Singular Name', 'text_domain' ), 
        'menu_name'                  => __( 'Writer', 'text_domain' ), 
        'all_items'                  => __( 'All Writer', 'text_domain' ), 
        'parent_item'                => __( 'Parent Writer', 'text_domain' ), 
        'parent_item_colon'          => __( 'Parent Writer:', 'text_domain' ), 
        'new_item_name'              => __( 'New Writer Name', 'text_domain' ), 
        'add_new_item'               => __( 'Add New Writer', 'text_domain' ), 
        'edit_item'                  => __( 'Edit Writer', 'text_domain' ), 
        'update_item'                => __( 'Update Writer', 'text_domain' ), 
        'separate_items_with_commas' => __( 'Separate Writer with commas', 'text_domain' ), 
        'search_items'               => __( 'Search Writer', 'text_domain' ), 
        'add_or_remove_items'        => __( 'Add or remove Writer', 'text_domain' ), 
        'choose_from_most_used'      => __( 'Choose from the most used Writer', 'text_domain' ), 
        'not_found'                  => __( 'Not Found', 'text_domain' ), 
    ); 
    $args = array( 
        'labels'                     => $labels, 
        'hierarchical'               => false, 
        'public'                     => true, 
        'show_ui'                    => true, 
        'show_admin_column'          => true, 
        'show_in_nav_menus'          => true, 
        'show_tagcloud'              => true, 
		'rewrite' => array( 
			'slug' => 'writer',
			'with_front' => FALSE,
		),
    ); 
    register_taxonomy( 'writer', array( 'series' ), $args ); 

} 

// Hook into the 'init' action 
add_action( 'init', 'writer', 0 ); 

function artist() { 
    $labels = array( 
        'name'                       => _x( 'Artist', 'Taxonomy General Name', 'text_domain' ), 
        'singular_name'              => _x( 'Artist', 'Taxonomy Singular Name', 'text_domain' ), 
        'menu_name'                  => __( 'Artist', 'text_domain' ), 
        'all_items'                  => __( 'All Artist', 'text_domain' ), 
        'parent_item'                => __( 'Parent Artist', 'text_domain' ), 
        'parent_item_colon'          => __( 'Parent Artist:', 'text_domain' ), 
        'new_item_name'              => __( 'New Artist Name', 'text_domain' ), 
        'add_new_item'               => __( 'Add New Artist', 'text_domain' ), 
        'edit_item'                  => __( 'Edit Artist', 'text_domain' ), 
        'update_item'                => __( 'Update Artist', 'text_domain' ), 
        'separate_items_with_commas' => __( 'Separate Artist with commas', 'text_domain' ), 
        'search_items'               => __( 'Search Artist', 'text_domain' ), 
        'add_or_remove_items'        => __( 'Add or remove artist', 'text_domain' ), 
        'choose_from_most_used'      => __( 'Choose from the most used artist', 'text_domain' ), 
        'not_found'                  => __( 'Not Found', 'text_domain' ), 
    ); 
    $args = array( 
        'labels'                     => $labels, 
        'hierarchical'               => false, 
        'public'                     => true, 
        'show_ui'                    => true, 
        'show_admin_column'          => true, 
        'show_in_nav_menus'          => true, 
        'show_tagcloud'              => true, 
		'rewrite' => array( 
			'slug' => 'artist',
			'with_front' => FALSE,
		),
    ); 
    register_taxonomy( 'artist', array( 'series' ), $args ); 

} 

// Hook into the 'init' action 
add_action( 'init', 'artist', 0 ); 